IF OBJECT_ID(N'Cbtes_Voucher_Tipos','U') IS NULL
BEGIN
	CREATE TABLE Cbtes_Voucher_Tipos(
		Id_Voucher_Tipo INT IDENTITY(1,1) NOT NULL,
		Descripcion VARCHAR(100) NOT NULL,
		Fecha_Desde DATE ,
		Fecha_Hasta DATE ,
		Fecha_Desde_Uso DATE ,
		Fecha_Hasta_Uso DATE ,
		Porc Decimal(5,2) ,
		Activo Tinyint
	 CONSTRAINT PK_CBTV_PorId PRIMARY KEY CLUSTERED 
		(
			Id_Voucher_Tipo ASC
		) 
	)
END

IF OBJECT_ID(N'Cbtes_Voucher_Suc','U') IS NULL
BEGIN
	CREATE TABLE Cbtes_Voucher_Suc(
		Id_Voucher_Suc INT IDENTITY(1,1) NOT NULL,
		Id_Voucher_Tipo INT ,
		Id_Sucursal SMALLINT 
	 CONSTRAINT PK_CBTVS_PorId PRIMARY KEY CLUSTERED 
		(
			Id_Voucher_Suc ASC
		) 
	)
END

IF OBJECT_ID(N'Cbtes_Voucher_PFam','U') IS NULL
BEGIN
	CREATE TABLE Cbtes_Voucher_PFam(
	    Id_Voucher_PFam INT IDENTITY(1,1) NOT NULL,
		Id_Voucher_Tipo INT ,
        Id_Familia INT,
		Porc Decimal(5,2) 
		CONSTRAINT PK_CBTVPF_PorId PRIMARY KEY CLUSTERED 
		(
			Id_Voucher_PFam ASC
		) 
	)
END

IF IndexProperty(Object_Id('Cbtes_Voucher_PFam'), 'IX_CBTVPF_PorFam', 'IndexID') IS  NULL
	CREATE INDEX IX_CBTVPF_PorFam ON Cbtes_Voucher_PFam (Id_Familia)
GO

IF OBJECT_ID('FK_CBTVPF_PorFam', 'F') IS NULL
	ALTER TABLE Cbtes_Voucher_PFam  ADD  CONSTRAINT FK_CBTVPF_PorFam FOREIGN KEY(Id_Familia)
	REFERENCES Prod_Familias (Id_Familia)
GO

IF IndexProperty(Object_Id('Cbtes_Voucher_Suc'), 'IX_CBTVS_PorSuc', 'IndexID') IS  NULL
	CREATE INDEX IX_CBTVS_PorSuc ON Cbtes_Voucher_Suc (Id_Sucursal)
GO

IF OBJECT_ID('FK_CBTVS_Sucusal', 'F') IS NULL
	ALTER TABLE Cbtes_Voucher_Suc  ADD  CONSTRAINT FK_CBTVS_Sucusal FOREIGN KEY(Id_Sucursal)
	REFERENCES Empresas_Suc (Id_Sucursal)
GO




